package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Dial invokes the cloudcallcenter.Dial API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dial.html
func (client *Client) Dial(request *DialRequest) (response *DialResponse, err error) {
	response = CreateDialResponse()
	err = client.DoAction(request, response)
	return
}

// DialWithChan invokes the cloudcallcenter.Dial API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DialWithChan(request *DialRequest) (<-chan *DialResponse, <-chan error) {
	responseChan := make(chan *DialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Dial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DialWithCallback invokes the cloudcallcenter.Dial API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DialWithCallback(request *DialRequest, callback func(response *DialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DialResponse
		var err error
		defer close(result)
		response, err = client.Dial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DialRequest is the request struct for api Dial
type DialRequest struct {
	*requests.RpcRequest
	ContactFlowId   string `position:"Query" name:"ContactFlowId"`
	BizName         string `position:"Query" name:"BizName"`
	Callee          string `position:"Query" name:"Callee"`
	RoutingStrategy string `position:"Query" name:"RoutingStrategy"`
	Caller          string `position:"Query" name:"Caller"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	Provider        string `position:"Query" name:"Provider"`
	AppId           string `position:"Query" name:"AppId"`
	AppToken        string `position:"Query" name:"AppToken"`
	Tag             string `position:"Query" name:"Tag"`
	ScenarioId      string `position:"Query" name:"ScenarioId"`
	ContactFlowName string `position:"Query" name:"ContactFlowName"`
	TaskId          string `position:"Query" name:"TaskId"`
	CabInstanceId   string `position:"Query" name:"CabInstanceId"`
}

// DialResponse is the response struct for api Dial
type DialResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	StatusCode     string `json:"StatusCode" xml:"StatusCode"`
	StatusDesc     string `json:"StatusDesc" xml:"StatusDesc"`
	TaskId         string `json:"TaskId" xml:"TaskId"`
	TimeStamp      string `json:"TimeStamp" xml:"TimeStamp"`
}

// CreateDialRequest creates a request to invoke Dial API
func CreateDialRequest() (request *DialRequest) {
	request = &DialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Dial", "", "")
	request.Method = requests.POST
	return
}

// CreateDialResponse creates a response to parse from Dial response
func CreateDialResponse() (response *DialResponse) {
	response = &DialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
