package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPredictiveJobs invokes the cloudcallcenter.ListPredictiveJobs API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobs.html
func (client *Client) ListPredictiveJobs(request *ListPredictiveJobsRequest) (response *ListPredictiveJobsResponse, err error) {
	response = CreateListPredictiveJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPredictiveJobsWithChan invokes the cloudcallcenter.ListPredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobsWithChan(request *ListPredictiveJobsRequest) (<-chan *ListPredictiveJobsResponse, <-chan error) {
	responseChan := make(chan *ListPredictiveJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPredictiveJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPredictiveJobsWithCallback invokes the cloudcallcenter.ListPredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobsWithCallback(request *ListPredictiveJobsRequest, callback func(response *ListPredictiveJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPredictiveJobsResponse
		var err error
		defer close(result)
		response, err = client.ListPredictiveJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPredictiveJobsRequest is the request struct for api ListPredictiveJobs
type ListPredictiveJobsRequest struct {
	*requests.RpcRequest
	TimeAlignment string           `position:"Query" name:"TimeAlignment"`
	JobStatus     string           `position:"Query" name:"JobStatus"`
	PhoneNumber   string           `position:"Query" name:"PhoneNumber"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ContactName   string           `position:"Query" name:"ContactName"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	SkillGroupId  string           `position:"Query" name:"SkillGroupId"`
	JobGroupId    string           `position:"Query" name:"JobGroupId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListPredictiveJobsResponse is the response struct for api ListPredictiveJobs
type ListPredictiveJobsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Jobs           Jobs   `json:"Jobs" xml:"Jobs"`
}

// CreateListPredictiveJobsRequest creates a request to invoke ListPredictiveJobs API
func CreateListPredictiveJobsRequest() (request *ListPredictiveJobsRequest) {
	request = &ListPredictiveJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPredictiveJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateListPredictiveJobsResponse creates a response to parse from ListPredictiveJobs response
func CreateListPredictiveJobsResponse() (response *ListPredictiveJobsResponse) {
	response = &ListPredictiveJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
