package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendPredefinedShortMessage invokes the cloudcallcenter.SendPredefinedShortMessage API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/sendpredefinedshortmessage.html
func (client *Client) SendPredefinedShortMessage(request *SendPredefinedShortMessageRequest) (response *SendPredefinedShortMessageResponse, err error) {
	response = CreateSendPredefinedShortMessageResponse()
	err = client.DoAction(request, response)
	return
}

// SendPredefinedShortMessageWithChan invokes the cloudcallcenter.SendPredefinedShortMessage API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/sendpredefinedshortmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendPredefinedShortMessageWithChan(request *SendPredefinedShortMessageRequest) (<-chan *SendPredefinedShortMessageResponse, <-chan error) {
	responseChan := make(chan *SendPredefinedShortMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendPredefinedShortMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendPredefinedShortMessageWithCallback invokes the cloudcallcenter.SendPredefinedShortMessage API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/sendpredefinedshortmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendPredefinedShortMessageWithCallback(request *SendPredefinedShortMessageRequest, callback func(response *SendPredefinedShortMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendPredefinedShortMessageResponse
		var err error
		defer close(result)
		response, err = client.SendPredefinedShortMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendPredefinedShortMessageRequest is the request struct for api SendPredefinedShortMessage
type SendPredefinedShortMessageRequest struct {
	*requests.RpcRequest
	InstanceId    string           `position:"Query" name:"InstanceId"`
	PhoneNumbers  string           `position:"Query" name:"PhoneNumbers"`
	ConfigId      requests.Integer `position:"Query" name:"ConfigId"`
	TemplateParam string           `position:"Query" name:"TemplateParam"`
}

// SendPredefinedShortMessageResponse is the response struct for api SendPredefinedShortMessage
type SendPredefinedShortMessageResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	BizId          string `json:"BizId" xml:"BizId"`
}

// CreateSendPredefinedShortMessageRequest creates a request to invoke SendPredefinedShortMessage API
func CreateSendPredefinedShortMessageRequest() (request *SendPredefinedShortMessageRequest) {
	request = &SendPredefinedShortMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "SendPredefinedShortMessage", "", "")
	request.Method = requests.POST
	return
}

// CreateSendPredefinedShortMessageResponse creates a response to parse from SendPredefinedShortMessage response
func CreateSendPredefinedShortMessageResponse() (response *SendPredefinedShortMessageResponse) {
	response = &SendPredefinedShortMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
