package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApRadioSsidConfig invokes the cloudwf.DeleteApRadioSsidConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapradiossidconfig.html
func (client *Client) DeleteApRadioSsidConfig(request *DeleteApRadioSsidConfigRequest) (response *DeleteApRadioSsidConfigResponse, err error) {
	response = CreateDeleteApRadioSsidConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApRadioSsidConfigWithChan invokes the cloudwf.DeleteApRadioSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapradiossidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApRadioSsidConfigWithChan(request *DeleteApRadioSsidConfigRequest) (<-chan *DeleteApRadioSsidConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteApRadioSsidConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApRadioSsidConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApRadioSsidConfigWithCallback invokes the cloudwf.DeleteApRadioSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapradiossidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApRadioSsidConfigWithCallback(request *DeleteApRadioSsidConfigRequest, callback func(response *DeleteApRadioSsidConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApRadioSsidConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteApRadioSsidConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApRadioSsidConfigRequest is the request struct for api DeleteApRadioSsidConfig
type DeleteApRadioSsidConfigRequest struct {
	*requests.RpcRequest
	InstantlyEffective requests.Integer `position:"Query" name:"InstantlyEffective"`
	Id                 requests.Integer `position:"Query" name:"Id"`
}

// DeleteApRadioSsidConfigResponse is the response struct for api DeleteApRadioSsidConfig
type DeleteApRadioSsidConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeleteApRadioSsidConfigRequest creates a request to invoke DeleteApRadioSsidConfig API
func CreateDeleteApRadioSsidConfigRequest() (request *DeleteApRadioSsidConfigRequest) {
	request = &DeleteApRadioSsidConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeleteApRadioSsidConfig", "cloudwf", "openAPI")
	return
}

// CreateDeleteApRadioSsidConfigResponse creates a response to parse from DeleteApRadioSsidConfig response
func CreateDeleteApRadioSsidConfigResponse() (response *DeleteApRadioSsidConfigResponse) {
	response = &DeleteApRadioSsidConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
