package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemFlowrateIntelligent invokes the cloudwf.OemFlowrateIntelligent API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateintelligent.html
func (client *Client) OemFlowrateIntelligent(request *OemFlowrateIntelligentRequest) (response *OemFlowrateIntelligentResponse, err error) {
	response = CreateOemFlowrateIntelligentResponse()
	err = client.DoAction(request, response)
	return
}

// OemFlowrateIntelligentWithChan invokes the cloudwf.OemFlowrateIntelligent API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateintelligent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateIntelligentWithChan(request *OemFlowrateIntelligentRequest) (<-chan *OemFlowrateIntelligentResponse, <-chan error) {
	responseChan := make(chan *OemFlowrateIntelligentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemFlowrateIntelligent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemFlowrateIntelligentWithCallback invokes the cloudwf.OemFlowrateIntelligent API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateintelligent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateIntelligentWithCallback(request *OemFlowrateIntelligentRequest, callback func(response *OemFlowrateIntelligentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemFlowrateIntelligentResponse
		var err error
		defer close(result)
		response, err = client.OemFlowrateIntelligent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemFlowrateIntelligentRequest is the request struct for api OemFlowrateIntelligent
type OemFlowrateIntelligentRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// OemFlowrateIntelligentResponse is the response struct for api OemFlowrateIntelligent
type OemFlowrateIntelligentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemFlowrateIntelligentRequest creates a request to invoke OemFlowrateIntelligent API
func CreateOemFlowrateIntelligentRequest() (request *OemFlowrateIntelligentRequest) {
	request = &OemFlowrateIntelligentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemFlowrateIntelligent", "cloudwf", "openAPI")
	return
}

// CreateOemFlowrateIntelligentResponse creates a response to parse from OemFlowrateIntelligent response
func CreateOemFlowrateIntelligentResponse() (response *OemFlowrateIntelligentResponse) {
	response = &OemFlowrateIntelligentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
