package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemHeatSetting invokes the cloudwf.OemHeatSetting API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatsetting.html
func (client *Client) OemHeatSetting(request *OemHeatSettingRequest) (response *OemHeatSettingResponse, err error) {
	response = CreateOemHeatSettingResponse()
	err = client.DoAction(request, response)
	return
}

// OemHeatSettingWithChan invokes the cloudwf.OemHeatSetting API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatSettingWithChan(request *OemHeatSettingRequest) (<-chan *OemHeatSettingResponse, <-chan error) {
	responseChan := make(chan *OemHeatSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemHeatSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemHeatSettingWithCallback invokes the cloudwf.OemHeatSetting API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatSettingWithCallback(request *OemHeatSettingRequest, callback func(response *OemHeatSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemHeatSettingResponse
		var err error
		defer close(result)
		response, err = client.OemHeatSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemHeatSettingRequest is the request struct for api OemHeatSetting
type OemHeatSettingRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// OemHeatSettingResponse is the response struct for api OemHeatSetting
type OemHeatSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemHeatSettingRequest creates a request to invoke OemHeatSetting API
func CreateOemHeatSettingRequest() (request *OemHeatSettingRequest) {
	request = &OemHeatSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemHeatSetting", "cloudwf", "openAPI")
	return
}

// CreateOemHeatSettingResponse creates a response to parse from OemHeatSetting response
func CreateOemHeatSettingResponse() (response *OemHeatSettingResponse) {
	response = &OemHeatSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
