package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveUmengPagePermission4Root invokes the cloudwf.SaveUmengPagePermission4Root API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveumengpagepermission4root.html
func (client *Client) SaveUmengPagePermission4Root(request *SaveUmengPagePermission4RootRequest) (response *SaveUmengPagePermission4RootResponse, err error) {
	response = CreateSaveUmengPagePermission4RootResponse()
	err = client.DoAction(request, response)
	return
}

// SaveUmengPagePermission4RootWithChan invokes the cloudwf.SaveUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveUmengPagePermission4RootWithChan(request *SaveUmengPagePermission4RootRequest) (<-chan *SaveUmengPagePermission4RootResponse, <-chan error) {
	responseChan := make(chan *SaveUmengPagePermission4RootResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveUmengPagePermission4Root(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveUmengPagePermission4RootWithCallback invokes the cloudwf.SaveUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveUmengPagePermission4RootWithCallback(request *SaveUmengPagePermission4RootRequest, callback func(response *SaveUmengPagePermission4RootResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveUmengPagePermission4RootResponse
		var err error
		defer close(result)
		response, err = client.SaveUmengPagePermission4Root(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveUmengPagePermission4RootRequest is the request struct for api SaveUmengPagePermission4Root
type SaveUmengPagePermission4RootRequest struct {
	*requests.RpcRequest
	GsPermission   string           `position:"Query" name:"GsPermission"`
	AliyunPk       requests.Integer `position:"Query" name:"AliyunPk"`
	PagePermission requests.Integer `position:"Query" name:"PagePermission"`
	Id             requests.Integer `position:"Query" name:"Id"`
	Bid            requests.Integer `position:"Query" name:"Bid"`
}

// SaveUmengPagePermission4RootResponse is the response struct for api SaveUmengPagePermission4Root
type SaveUmengPagePermission4RootResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveUmengPagePermission4RootRequest creates a request to invoke SaveUmengPagePermission4Root API
func CreateSaveUmengPagePermission4RootRequest() (request *SaveUmengPagePermission4RootRequest) {
	request = &SaveUmengPagePermission4RootRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveUmengPagePermission4Root", "cloudwf", "openAPI")
	return
}

// CreateSaveUmengPagePermission4RootResponse creates a response to parse from SaveUmengPagePermission4Root response
func CreateSaveUmengPagePermission4RootResponse() (response *SaveUmengPagePermission4RootResponse) {
	response = &SaveUmengPagePermission4RootResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
