package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateConfigRuleSummaryByRiskLevel invokes the config.GetAggregateConfigRuleSummaryByRiskLevel API synchronously
func (client *Client) GetAggregateConfigRuleSummaryByRiskLevel(request *GetAggregateConfigRuleSummaryByRiskLevelRequest) (response *GetAggregateConfigRuleSummaryByRiskLevelResponse, err error) {
	response = CreateGetAggregateConfigRuleSummaryByRiskLevelResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateConfigRuleSummaryByRiskLevelWithChan invokes the config.GetAggregateConfigRuleSummaryByRiskLevel API asynchronously
func (client *Client) GetAggregateConfigRuleSummaryByRiskLevelWithChan(request *GetAggregateConfigRuleSummaryByRiskLevelRequest) (<-chan *GetAggregateConfigRuleSummaryByRiskLevelResponse, <-chan error) {
	responseChan := make(chan *GetAggregateConfigRuleSummaryByRiskLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateConfigRuleSummaryByRiskLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateConfigRuleSummaryByRiskLevelWithCallback invokes the config.GetAggregateConfigRuleSummaryByRiskLevel API asynchronously
func (client *Client) GetAggregateConfigRuleSummaryByRiskLevelWithCallback(request *GetAggregateConfigRuleSummaryByRiskLevelRequest, callback func(response *GetAggregateConfigRuleSummaryByRiskLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateConfigRuleSummaryByRiskLevelResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateConfigRuleSummaryByRiskLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateConfigRuleSummaryByRiskLevelRequest is the request struct for api GetAggregateConfigRuleSummaryByRiskLevel
type GetAggregateConfigRuleSummaryByRiskLevelRequest struct {
	*requests.RpcRequest
	AggregatorId string `position:"Query" name:"AggregatorId"`
}

// GetAggregateConfigRuleSummaryByRiskLevelResponse is the response struct for api GetAggregateConfigRuleSummaryByRiskLevel
type GetAggregateConfigRuleSummaryByRiskLevelResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	ConfigRuleSummaries []Data `json:"ConfigRuleSummaries" xml:"ConfigRuleSummaries"`
}

// CreateGetAggregateConfigRuleSummaryByRiskLevelRequest creates a request to invoke GetAggregateConfigRuleSummaryByRiskLevel API
func CreateGetAggregateConfigRuleSummaryByRiskLevelRequest() (request *GetAggregateConfigRuleSummaryByRiskLevelRequest) {
	request = &GetAggregateConfigRuleSummaryByRiskLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateConfigRuleSummaryByRiskLevel", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateConfigRuleSummaryByRiskLevelResponse creates a response to parse from GetAggregateConfigRuleSummaryByRiskLevel response
func CreateGetAggregateConfigRuleSummaryByRiskLevelResponse() (response *GetAggregateConfigRuleSummaryByRiskLevelResponse) {
	response = &GetAggregateConfigRuleSummaryByRiskLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
