package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceComplianceGroupByResourceType invokes the config.GetResourceComplianceGroupByResourceType API synchronously
func (client *Client) GetResourceComplianceGroupByResourceType(request *GetResourceComplianceGroupByResourceTypeRequest) (response *GetResourceComplianceGroupByResourceTypeResponse, err error) {
	response = CreateGetResourceComplianceGroupByResourceTypeResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceComplianceGroupByResourceTypeWithChan invokes the config.GetResourceComplianceGroupByResourceType API asynchronously
func (client *Client) GetResourceComplianceGroupByResourceTypeWithChan(request *GetResourceComplianceGroupByResourceTypeRequest) (<-chan *GetResourceComplianceGroupByResourceTypeResponse, <-chan error) {
	responseChan := make(chan *GetResourceComplianceGroupByResourceTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceComplianceGroupByResourceType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceComplianceGroupByResourceTypeWithCallback invokes the config.GetResourceComplianceGroupByResourceType API asynchronously
func (client *Client) GetResourceComplianceGroupByResourceTypeWithCallback(request *GetResourceComplianceGroupByResourceTypeRequest, callback func(response *GetResourceComplianceGroupByResourceTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceComplianceGroupByResourceTypeResponse
		var err error
		defer close(result)
		response, err = client.GetResourceComplianceGroupByResourceType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceComplianceGroupByResourceTypeRequest is the request struct for api GetResourceComplianceGroupByResourceType
type GetResourceComplianceGroupByResourceTypeRequest struct {
	*requests.RpcRequest
	ConfigRuleIds string `position:"Query" name:"ConfigRuleIds"`
}

// GetResourceComplianceGroupByResourceTypeResponse is the response struct for api GetResourceComplianceGroupByResourceType
type GetResourceComplianceGroupByResourceTypeResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ComplianceResult ComplianceResult `json:"ComplianceResult" xml:"ComplianceResult"`
}

// CreateGetResourceComplianceGroupByResourceTypeRequest creates a request to invoke GetResourceComplianceGroupByResourceType API
func CreateGetResourceComplianceGroupByResourceTypeRequest() (request *GetResourceComplianceGroupByResourceTypeRequest) {
	request = &GetResourceComplianceGroupByResourceTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetResourceComplianceGroupByResourceType", "", "")
	request.Method = requests.POST
	return
}

// CreateGetResourceComplianceGroupByResourceTypeResponse creates a response to parse from GetResourceComplianceGroupByResourceType response
func CreateGetResourceComplianceGroupByResourceTypeResponse() (response *GetResourceComplianceGroupByResourceTypeResponse) {
	response = &GetResourceComplianceGroupByResourceTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
