package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRepository invokes the cr.UpdateRepository API synchronously
// api document: https://help.aliyun.com/api/cr/updaterepository.html
func (client *Client) UpdateRepository(request *UpdateRepositoryRequest) (response *UpdateRepositoryResponse, err error) {
	response = CreateUpdateRepositoryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRepositoryWithChan invokes the cr.UpdateRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/updaterepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepositoryWithChan(request *UpdateRepositoryRequest) (<-chan *UpdateRepositoryResponse, <-chan error) {
	responseChan := make(chan *UpdateRepositoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRepository(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRepositoryWithCallback invokes the cr.UpdateRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/updaterepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepositoryWithCallback(request *UpdateRepositoryRequest, callback func(response *UpdateRepositoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRepositoryResponse
		var err error
		defer close(result)
		response, err = client.UpdateRepository(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRepositoryRequest is the request struct for api UpdateRepository
type UpdateRepositoryRequest struct {
	*requests.RpcRequest
	RepoType   string `position:"Query" name:"RepoType"`
	Summary    string `position:"Query" name:"Summary"`
	RepoId     string `position:"Query" name:"RepoId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Detail     string `position:"Query" name:"Detail"`
}

// UpdateRepositoryResponse is the response struct for api UpdateRepository
type UpdateRepositoryResponse struct {
	*responses.BaseResponse
	UpdateRepositoryIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string `json:"Code" xml:"Code"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRepositoryRequest creates a request to invoke UpdateRepository API
func CreateUpdateRepositoryRequest() (request *UpdateRepositoryRequest) {
	request = &UpdateRepositoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "UpdateRepository", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRepositoryResponse creates a response to parse from UpdateRepository response
func CreateUpdateRepositoryResponse() (response *UpdateRepositoryResponse) {
	response = &UpdateRepositoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
