package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddIdentityCertifiedForBidUser invokes the crm.AddIdentityCertifiedForBidUser API synchronously
// api document: https://help.aliyun.com/api/crm/addidentitycertifiedforbiduser.html
func (client *Client) AddIdentityCertifiedForBidUser(request *AddIdentityCertifiedForBidUserRequest) (response *AddIdentityCertifiedForBidUserResponse, err error) {
	response = CreateAddIdentityCertifiedForBidUserResponse()
	err = client.DoAction(request, response)
	return
}

// AddIdentityCertifiedForBidUserWithChan invokes the crm.AddIdentityCertifiedForBidUser API asynchronously
// api document: https://help.aliyun.com/api/crm/addidentitycertifiedforbiduser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddIdentityCertifiedForBidUserWithChan(request *AddIdentityCertifiedForBidUserRequest) (<-chan *AddIdentityCertifiedForBidUserResponse, <-chan error) {
	responseChan := make(chan *AddIdentityCertifiedForBidUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddIdentityCertifiedForBidUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddIdentityCertifiedForBidUserWithCallback invokes the crm.AddIdentityCertifiedForBidUser API asynchronously
// api document: https://help.aliyun.com/api/crm/addidentitycertifiedforbiduser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddIdentityCertifiedForBidUserWithCallback(request *AddIdentityCertifiedForBidUserRequest, callback func(response *AddIdentityCertifiedForBidUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddIdentityCertifiedForBidUserResponse
		var err error
		defer close(result)
		response, err = client.AddIdentityCertifiedForBidUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddIdentityCertifiedForBidUserRequest is the request struct for api AddIdentityCertifiedForBidUser
type AddIdentityCertifiedForBidUserRequest struct {
	*requests.RpcRequest
	BidType       string           `position:"Query" name:"BidType"`
	LicenseNumber string           `position:"Query" name:"LicenseNumber"`
	LicenseType   string           `position:"Query" name:"LicenseType"`
	Phone         string           `position:"Query" name:"Phone"`
	Name          string           `position:"Query" name:"Name"`
	PK            string           `position:"Query" name:"PK"`
	IsEnterprise  requests.Boolean `position:"Query" name:"IsEnterprise"`
}

// AddIdentityCertifiedForBidUserResponse is the response struct for api AddIdentityCertifiedForBidUser
type AddIdentityCertifiedForBidUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateAddIdentityCertifiedForBidUserRequest creates a request to invoke AddIdentityCertifiedForBidUser API
func CreateAddIdentityCertifiedForBidUserRequest() (request *AddIdentityCertifiedForBidUserRequest) {
	request = &AddIdentityCertifiedForBidUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "AddIdentityCertifiedForBidUser", "crm", "openAPI")
	return
}

// CreateAddIdentityCertifiedForBidUserResponse creates a response to parse from AddIdentityCertifiedForBidUser response
func CreateAddIdentityCertifiedForBidUserResponse() (response *AddIdentityCertifiedForBidUserResponse) {
	response = &AddIdentityCertifiedForBidUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
