package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckLabelForBid invokes the crm.CheckLabelForBid API synchronously
// api document: https://help.aliyun.com/api/crm/checklabelforbid.html
func (client *Client) CheckLabelForBid(request *CheckLabelForBidRequest) (response *CheckLabelForBidResponse, err error) {
	response = CreateCheckLabelForBidResponse()
	err = client.DoAction(request, response)
	return
}

// CheckLabelForBidWithChan invokes the crm.CheckLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/checklabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckLabelForBidWithChan(request *CheckLabelForBidRequest) (<-chan *CheckLabelForBidResponse, <-chan error) {
	responseChan := make(chan *CheckLabelForBidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckLabelForBid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckLabelForBidWithCallback invokes the crm.CheckLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/checklabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckLabelForBidWithCallback(request *CheckLabelForBidRequest, callback func(response *CheckLabelForBidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckLabelForBidResponse
		var err error
		defer close(result)
		response, err = client.CheckLabelForBid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckLabelForBidRequest is the request struct for api CheckLabelForBid
type CheckLabelForBidRequest struct {
	*requests.RpcRequest
	LabelSeries string `position:"Query" name:"LabelSeries"`
	PK          string `position:"Query" name:"PK"`
	Label       string `position:"Query" name:"Label"`
}

// CheckLabelForBidResponse is the response struct for api CheckLabelForBid
type CheckLabelForBidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCheckLabelForBidRequest creates a request to invoke CheckLabelForBid API
func CreateCheckLabelForBidRequest() (request *CheckLabelForBidRequest) {
	request = &CheckLabelForBidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "CheckLabelForBid", "crm", "openAPI")
	return
}

// CreateCheckLabelForBidResponse creates a response to parse from CheckLabelForBid response
func CreateCheckLabelForBidResponse() (response *CheckLabelForBidResponse) {
	response = &CheckLabelForBidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
