package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckSLRDelete invokes the csb.CheckSLRDelete API synchronously
// api document: https://help.aliyun.com/api/csb/checkslrdelete.html
func (client *Client) CheckSLRDelete(request *CheckSLRDeleteRequest) (response *CheckSLRDeleteResponse, err error) {
	response = CreateCheckSLRDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// CheckSLRDeleteWithChan invokes the csb.CheckSLRDelete API asynchronously
// api document: https://help.aliyun.com/api/csb/checkslrdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckSLRDeleteWithChan(request *CheckSLRDeleteRequest) (<-chan *CheckSLRDeleteResponse, <-chan error) {
	responseChan := make(chan *CheckSLRDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckSLRDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckSLRDeleteWithCallback invokes the csb.CheckSLRDelete API asynchronously
// api document: https://help.aliyun.com/api/csb/checkslrdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckSLRDeleteWithCallback(request *CheckSLRDeleteRequest, callback func(response *CheckSLRDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckSLRDeleteResponse
		var err error
		defer close(result)
		response, err = client.CheckSLRDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckSLRDeleteRequest is the request struct for api CheckSLRDelete
type CheckSLRDeleteRequest struct {
	*requests.RpcRequest
	DeletionTaskId string `position:"Query" name:"DeletionTaskId"`
	AccountId      string `position:"Query" name:"AccountId"`
	SPIRegionId    string `position:"Query" name:"SPIRegionId"`
	RoleArn        string `position:"Query" name:"RoleArn"`
	ServiceName    string `position:"Query" name:"ServiceName"`
}

// CheckSLRDeleteResponse is the response struct for api CheckSLRDelete
type CheckSLRDeleteResponse struct {
	*responses.BaseResponse
	Deletable  bool        `json:"Deletable" xml:"Deletable"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Code       int         `json:"Code" xml:"Code"`
	Message    string      `json:"Message" xml:"Message"`
	RoleUsages []RoleUsage `json:"RoleUsages" xml:"RoleUsages"`
}

// CreateCheckSLRDeleteRequest creates a request to invoke CheckSLRDelete API
func CreateCheckSLRDeleteRequest() (request *CheckSLRDeleteRequest) {
	request = &CheckSLRDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "CheckSLRDelete", "", "")
	request.Method = requests.GET
	return
}

// CreateCheckSLRDeleteResponse creates a response to parse from CheckSLRDelete response
func CreateCheckSLRDeleteResponse() (response *CheckSLRDeleteResponse) {
	response = &CheckSLRDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
