package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncErrorRequestStatByCode invokes the das.GetAsyncErrorRequestStatByCode API synchronously
func (client *Client) GetAsyncErrorRequestStatByCode(request *GetAsyncErrorRequestStatByCodeRequest) (response *GetAsyncErrorRequestStatByCodeResponse, err error) {
	response = CreateGetAsyncErrorRequestStatByCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncErrorRequestStatByCodeWithChan invokes the das.GetAsyncErrorRequestStatByCode API asynchronously
func (client *Client) GetAsyncErrorRequestStatByCodeWithChan(request *GetAsyncErrorRequestStatByCodeRequest) (<-chan *GetAsyncErrorRequestStatByCodeResponse, <-chan error) {
	responseChan := make(chan *GetAsyncErrorRequestStatByCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncErrorRequestStatByCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncErrorRequestStatByCodeWithCallback invokes the das.GetAsyncErrorRequestStatByCode API asynchronously
func (client *Client) GetAsyncErrorRequestStatByCodeWithCallback(request *GetAsyncErrorRequestStatByCodeRequest, callback func(response *GetAsyncErrorRequestStatByCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncErrorRequestStatByCodeResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncErrorRequestStatByCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncErrorRequestStatByCodeRequest is the request struct for api GetAsyncErrorRequestStatByCode
type GetAsyncErrorRequestStatByCodeRequest struct {
	*requests.RpcRequest
	Role           string `position:"Query" name:"Role"`
	Start          string `position:"Query" name:"Start"`
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	End            string `position:"Query" name:"End"`
	NodeId         string `position:"Query" name:"NodeId"`
}

// GetAsyncErrorRequestStatByCodeResponse is the response struct for api GetAsyncErrorRequestStatByCode
type GetAsyncErrorRequestStatByCodeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetAsyncErrorRequestStatByCodeRequest creates a request to invoke GetAsyncErrorRequestStatByCode API
func CreateGetAsyncErrorRequestStatByCodeRequest() (request *GetAsyncErrorRequestStatByCodeRequest) {
	request = &GetAsyncErrorRequestStatByCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAsyncErrorRequestStatByCode", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAsyncErrorRequestStatByCodeResponse creates a response to parse from GetAsyncErrorRequestStatByCode response
func CreateGetAsyncErrorRequestStatByCodeResponse() (response *GetAsyncErrorRequestStatByCodeResponse) {
	response = &GetAsyncErrorRequestStatByCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
