package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteQualityFollower invokes the dataworks_public.DeleteQualityFollower API synchronously
func (client *Client) DeleteQualityFollower(request *DeleteQualityFollowerRequest) (response *DeleteQualityFollowerResponse, err error) {
	response = CreateDeleteQualityFollowerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteQualityFollowerWithChan invokes the dataworks_public.DeleteQualityFollower API asynchronously
func (client *Client) DeleteQualityFollowerWithChan(request *DeleteQualityFollowerRequest) (<-chan *DeleteQualityFollowerResponse, <-chan error) {
	responseChan := make(chan *DeleteQualityFollowerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteQualityFollower(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteQualityFollowerWithCallback invokes the dataworks_public.DeleteQualityFollower API asynchronously
func (client *Client) DeleteQualityFollowerWithCallback(request *DeleteQualityFollowerRequest, callback func(response *DeleteQualityFollowerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteQualityFollowerResponse
		var err error
		defer close(result)
		response, err = client.DeleteQualityFollower(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteQualityFollowerRequest is the request struct for api DeleteQualityFollower
type DeleteQualityFollowerRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Body" name:"ProjectName"`
	FollowerId  requests.Integer `position:"Body" name:"FollowerId"`
}

// DeleteQualityFollowerResponse is the response struct for api DeleteQualityFollower
type DeleteQualityFollowerResponse struct {
	*responses.BaseResponse
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           bool   `json:"Data" xml:"Data"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteQualityFollowerRequest creates a request to invoke DeleteQualityFollower API
func CreateDeleteQualityFollowerRequest() (request *DeleteQualityFollowerRequest) {
	request = &DeleteQualityFollowerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteQualityFollower", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteQualityFollowerResponse creates a response to parse from DeleteQualityFollower response
func CreateDeleteQualityFollowerResponse() (response *DeleteQualityFollowerResponse) {
	response = &DeleteQualityFollowerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
