package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpSensitiveData invokes the dataworks_public.GetOpSensitiveData API synchronously
func (client *Client) GetOpSensitiveData(request *GetOpSensitiveDataRequest) (response *GetOpSensitiveDataResponse, err error) {
	response = CreateGetOpSensitiveDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpSensitiveDataWithChan invokes the dataworks_public.GetOpSensitiveData API asynchronously
func (client *Client) GetOpSensitiveDataWithChan(request *GetOpSensitiveDataRequest) (<-chan *GetOpSensitiveDataResponse, <-chan error) {
	responseChan := make(chan *GetOpSensitiveDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpSensitiveData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpSensitiveDataWithCallback invokes the dataworks_public.GetOpSensitiveData API asynchronously
func (client *Client) GetOpSensitiveDataWithCallback(request *GetOpSensitiveDataRequest, callback func(response *GetOpSensitiveDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpSensitiveDataResponse
		var err error
		defer close(result)
		response, err = client.GetOpSensitiveData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpSensitiveDataRequest is the request struct for api GetOpSensitiveData
type GetOpSensitiveDataRequest struct {
	*requests.RpcRequest
	Date     string           `position:"Query" name:"Date"`
	OpType   string           `position:"Query" name:"OpType"`
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	Name     string           `position:"Query" name:"Name"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// GetOpSensitiveDataResponse is the response struct for api GetOpSensitiveData
type GetOpSensitiveDataResponse struct {
	*responses.BaseResponse
	OpSensitiveData string `json:"OpSensitiveData" xml:"OpSensitiveData"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateGetOpSensitiveDataRequest creates a request to invoke GetOpSensitiveData API
func CreateGetOpSensitiveDataRequest() (request *GetOpSensitiveDataRequest) {
	request = &GetOpSensitiveDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetOpSensitiveData", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOpSensitiveDataResponse creates a response to parse from GetOpSensitiveData response
func CreateGetOpSensitiveDataResponse() (response *GetOpSensitiveDataResponse) {
	response = &GetOpSensitiveDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
