package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlertMessages invokes the dataworks_public.ListAlertMessages API synchronously
func (client *Client) ListAlertMessages(request *ListAlertMessagesRequest) (response *ListAlertMessagesResponse, err error) {
	response = CreateListAlertMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlertMessagesWithChan invokes the dataworks_public.ListAlertMessages API asynchronously
func (client *Client) ListAlertMessagesWithChan(request *ListAlertMessagesRequest) (<-chan *ListAlertMessagesResponse, <-chan error) {
	responseChan := make(chan *ListAlertMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlertMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlertMessagesWithCallback invokes the dataworks_public.ListAlertMessages API asynchronously
func (client *Client) ListAlertMessagesWithCallback(request *ListAlertMessagesRequest, callback func(response *ListAlertMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlertMessagesResponse
		var err error
		defer close(result)
		response, err = client.ListAlertMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlertMessagesRequest is the request struct for api ListAlertMessages
type ListAlertMessagesRequest struct {
	*requests.RpcRequest
	AlertUser      string           `position:"Body" name:"AlertUser"`
	EndTime        string           `position:"Body" name:"EndTime"`
	BeginTime      string           `position:"Body" name:"BeginTime"`
	AlertMethods   string           `position:"Body" name:"AlertMethods"`
	PageNumber     requests.Integer `position:"Body" name:"PageNumber"`
	RemindId       requests.Integer `position:"Body" name:"RemindId"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
	AlertRuleTypes string           `position:"Body" name:"AlertRuleTypes"`
}

// ListAlertMessagesResponse is the response struct for api ListAlertMessages
type ListAlertMessagesResponse struct {
	*responses.BaseResponse
	Success        bool                    `json:"Success" xml:"Success"`
	ErrorCode      string                  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int                     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string                  `json:"RequestId" xml:"RequestId"`
	Data           DataInListAlertMessages `json:"Data" xml:"Data"`
}

// CreateListAlertMessagesRequest creates a request to invoke ListAlertMessages API
func CreateListAlertMessagesRequest() (request *ListAlertMessagesRequest) {
	request = &ListAlertMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListAlertMessages", "", "")
	request.Method = requests.POST
	return
}

// CreateListAlertMessagesResponse creates a response to parse from ListAlertMessages response
func CreateListAlertMessagesResponse() (response *ListAlertMessagesResponse) {
	response = &ListAlertMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
