package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSuccessInstanceAmount invokes the dataworks_public.ListSuccessInstanceAmount API synchronously
func (client *Client) ListSuccessInstanceAmount(request *ListSuccessInstanceAmountRequest) (response *ListSuccessInstanceAmountResponse, err error) {
	response = CreateListSuccessInstanceAmountResponse()
	err = client.DoAction(request, response)
	return
}

// ListSuccessInstanceAmountWithChan invokes the dataworks_public.ListSuccessInstanceAmount API asynchronously
func (client *Client) ListSuccessInstanceAmountWithChan(request *ListSuccessInstanceAmountRequest) (<-chan *ListSuccessInstanceAmountResponse, <-chan error) {
	responseChan := make(chan *ListSuccessInstanceAmountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSuccessInstanceAmount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSuccessInstanceAmountWithCallback invokes the dataworks_public.ListSuccessInstanceAmount API asynchronously
func (client *Client) ListSuccessInstanceAmountWithCallback(request *ListSuccessInstanceAmountRequest, callback func(response *ListSuccessInstanceAmountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSuccessInstanceAmountResponse
		var err error
		defer close(result)
		response, err = client.ListSuccessInstanceAmount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSuccessInstanceAmountRequest is the request struct for api ListSuccessInstanceAmount
type ListSuccessInstanceAmountRequest struct {
	*requests.RpcRequest
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// ListSuccessInstanceAmountResponse is the response struct for api ListSuccessInstanceAmount
type ListSuccessInstanceAmountResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	InstanceStatusTrend InstanceStatusTrend `json:"InstanceStatusTrend" xml:"InstanceStatusTrend"`
}

// CreateListSuccessInstanceAmountRequest creates a request to invoke ListSuccessInstanceAmount API
func CreateListSuccessInstanceAmountRequest() (request *ListSuccessInstanceAmountRequest) {
	request = &ListSuccessInstanceAmountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListSuccessInstanceAmount", "", "")
	request.Method = requests.POST
	return
}

// CreateListSuccessInstanceAmountResponse creates a response to parse from ListSuccessInstanceAmount response
func CreateListSuccessInstanceAmountResponse() (response *ListSuccessInstanceAmountResponse) {
	response = &ListSuccessInstanceAmountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
