package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnIpaSpecificConfig invokes the dcdn.DeleteDcdnIpaSpecificConfig API synchronously
func (client *Client) DeleteDcdnIpaSpecificConfig(request *DeleteDcdnIpaSpecificConfigRequest) (response *DeleteDcdnIpaSpecificConfigResponse, err error) {
	response = CreateDeleteDcdnIpaSpecificConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnIpaSpecificConfigWithChan invokes the dcdn.DeleteDcdnIpaSpecificConfig API asynchronously
func (client *Client) DeleteDcdnIpaSpecificConfigWithChan(request *DeleteDcdnIpaSpecificConfigRequest) (<-chan *DeleteDcdnIpaSpecificConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnIpaSpecificConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnIpaSpecificConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnIpaSpecificConfigWithCallback invokes the dcdn.DeleteDcdnIpaSpecificConfig API asynchronously
func (client *Client) DeleteDcdnIpaSpecificConfigWithCallback(request *DeleteDcdnIpaSpecificConfigRequest, callback func(response *DeleteDcdnIpaSpecificConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnIpaSpecificConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnIpaSpecificConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnIpaSpecificConfigRequest is the request struct for api DeleteDcdnIpaSpecificConfig
type DeleteDcdnIpaSpecificConfigRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
}

// DeleteDcdnIpaSpecificConfigResponse is the response struct for api DeleteDcdnIpaSpecificConfig
type DeleteDcdnIpaSpecificConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnIpaSpecificConfigRequest creates a request to invoke DeleteDcdnIpaSpecificConfig API
func CreateDeleteDcdnIpaSpecificConfigRequest() (request *DeleteDcdnIpaSpecificConfigRequest) {
	request = &DeleteDcdnIpaSpecificConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnIpaSpecificConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnIpaSpecificConfigResponse creates a response to parse from DeleteDcdnIpaSpecificConfig response
func CreateDeleteDcdnIpaSpecificConfigResponse() (response *DeleteDcdnIpaSpecificConfigResponse) {
	response = &DeleteDcdnIpaSpecificConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
