package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableLayer7CC invokes the ddoscoo.DisableLayer7CC API synchronously
func (client *Client) DisableLayer7CC(request *DisableLayer7CCRequest) (response *DisableLayer7CCResponse, err error) {
	response = CreateDisableLayer7CCResponse()
	err = client.DoAction(request, response)
	return
}

// DisableLayer7CCWithChan invokes the ddoscoo.DisableLayer7CC API asynchronously
func (client *Client) DisableLayer7CCWithChan(request *DisableLayer7CCRequest) (<-chan *DisableLayer7CCResponse, <-chan error) {
	responseChan := make(chan *DisableLayer7CCResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableLayer7CC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableLayer7CCWithCallback invokes the ddoscoo.DisableLayer7CC API asynchronously
func (client *Client) DisableLayer7CCWithCallback(request *DisableLayer7CCRequest, callback func(response *DisableLayer7CCResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableLayer7CCResponse
		var err error
		defer close(result)
		response, err = client.DisableLayer7CC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableLayer7CCRequest is the request struct for api DisableLayer7CC
type DisableLayer7CCRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// DisableLayer7CCResponse is the response struct for api DisableLayer7CC
type DisableLayer7CCResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableLayer7CCRequest creates a request to invoke DisableLayer7CC API
func CreateDisableLayer7CCRequest() (request *DisableLayer7CCRequest) {
	request = &DisableLayer7CCRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DisableLayer7CC", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableLayer7CCResponse creates a response to parse from DisableLayer7CC response
func CreateDisableLayer7CCResponse() (response *DisableLayer7CCResponse) {
	response = &DisableLayer7CCResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
