package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectCustomFields invokes the devops_rdc.ListProjectCustomFields API synchronously
func (client *Client) ListProjectCustomFields(request *ListProjectCustomFieldsRequest) (response *ListProjectCustomFieldsResponse, err error) {
	response = CreateListProjectCustomFieldsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectCustomFieldsWithChan invokes the devops_rdc.ListProjectCustomFields API asynchronously
func (client *Client) ListProjectCustomFieldsWithChan(request *ListProjectCustomFieldsRequest) (<-chan *ListProjectCustomFieldsResponse, <-chan error) {
	responseChan := make(chan *ListProjectCustomFieldsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectCustomFields(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectCustomFieldsWithCallback invokes the devops_rdc.ListProjectCustomFields API asynchronously
func (client *Client) ListProjectCustomFieldsWithCallback(request *ListProjectCustomFieldsRequest, callback func(response *ListProjectCustomFieldsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectCustomFieldsResponse
		var err error
		defer close(result)
		response, err = client.ListProjectCustomFields(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectCustomFieldsRequest is the request struct for api ListProjectCustomFields
type ListProjectCustomFieldsRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListProjectCustomFieldsResponse is the response struct for api ListProjectCustomFields
type ListProjectCustomFieldsResponse struct {
	*responses.BaseResponse
	Successful bool          `json:"Successful" xml:"Successful"`
	ErrorCode  string        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string        `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	Object     []CustomField `json:"Object" xml:"Object"`
}

// CreateListProjectCustomFieldsRequest creates a request to invoke ListProjectCustomFields API
func CreateListProjectCustomFieldsRequest() (request *ListProjectCustomFieldsRequest) {
	request = &ListProjectCustomFieldsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListProjectCustomFields", "", "")
	request.Method = requests.POST
	return
}

// CreateListProjectCustomFieldsResponse creates a response to parse from ListProjectCustomFields response
func CreateListProjectCustomFieldsResponse() (response *ListProjectCustomFieldsResponse) {
	response = &ListProjectCustomFieldsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
