package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveReceiverDetail invokes the dm.SaveReceiverDetail API synchronously
// api document: https://help.aliyun.com/api/dm/savereceiverdetail.html
func (client *Client) SaveReceiverDetail(request *SaveReceiverDetailRequest) (response *SaveReceiverDetailResponse, err error) {
	response = CreateSaveReceiverDetailResponse()
	err = client.DoAction(request, response)
	return
}

// SaveReceiverDetailWithChan invokes the dm.SaveReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/savereceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveReceiverDetailWithChan(request *SaveReceiverDetailRequest) (<-chan *SaveReceiverDetailResponse, <-chan error) {
	responseChan := make(chan *SaveReceiverDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveReceiverDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveReceiverDetailWithCallback invokes the dm.SaveReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/savereceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveReceiverDetailWithCallback(request *SaveReceiverDetailRequest, callback func(response *SaveReceiverDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveReceiverDetailResponse
		var err error
		defer close(result)
		response, err = client.SaveReceiverDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveReceiverDetailRequest is the request struct for api SaveReceiverDetail
type SaveReceiverDetailRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReceiverId           string           `position:"Query" name:"ReceiverId"`
	Detail               string           `position:"Query" name:"Detail"`
}

// SaveReceiverDetailResponse is the response struct for api SaveReceiverDetail
type SaveReceiverDetailResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	SuccessCount int                      `json:"SuccessCount" xml:"SuccessCount"`
	ErrorCount   int                      `json:"ErrorCount" xml:"ErrorCount"`
	Data         DataInSaveReceiverDetail `json:"Data" xml:"Data"`
}

// CreateSaveReceiverDetailRequest creates a request to invoke SaveReceiverDetail API
func CreateSaveReceiverDetailRequest() (request *SaveReceiverDetailRequest) {
	request = &SaveReceiverDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "SaveReceiverDetail", "", "")
	return
}

// CreateSaveReceiverDetailResponse creates a response to parse from SaveReceiverDetail response
func CreateSaveReceiverDetailResponse() (response *SaveReceiverDetailResponse) {
	response = &SaveReceiverDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
