package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLogicDatabase invokes the dms_enterprise.DeleteLogicDatabase API synchronously
func (client *Client) DeleteLogicDatabase(request *DeleteLogicDatabaseRequest) (response *DeleteLogicDatabaseResponse, err error) {
	response = CreateDeleteLogicDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLogicDatabaseWithChan invokes the dms_enterprise.DeleteLogicDatabase API asynchronously
func (client *Client) DeleteLogicDatabaseWithChan(request *DeleteLogicDatabaseRequest) (<-chan *DeleteLogicDatabaseResponse, <-chan error) {
	responseChan := make(chan *DeleteLogicDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLogicDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLogicDatabaseWithCallback invokes the dms_enterprise.DeleteLogicDatabase API asynchronously
func (client *Client) DeleteLogicDatabaseWithCallback(request *DeleteLogicDatabaseRequest, callback func(response *DeleteLogicDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLogicDatabaseResponse
		var err error
		defer close(result)
		response, err = client.DeleteLogicDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLogicDatabaseRequest is the request struct for api DeleteLogicDatabase
type DeleteLogicDatabaseRequest struct {
	*requests.RpcRequest
	LogicDbId requests.Integer `position:"Query" name:"LogicDbId"`
	Tid       requests.Integer `position:"Query" name:"Tid"`
}

// DeleteLogicDatabaseResponse is the response struct for api DeleteLogicDatabase
type DeleteLogicDatabaseResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteLogicDatabaseRequest creates a request to invoke DeleteLogicDatabase API
func CreateDeleteLogicDatabaseRequest() (request *DeleteLogicDatabaseRequest) {
	request = &DeleteLogicDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteLogicDatabase", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLogicDatabaseResponse creates a response to parse from DeleteLogicDatabase response
func CreateDeleteLogicDatabaseResponse() (response *DeleteLogicDatabaseResponse) {
	response = &DeleteLogicDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
