package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSensitiveColumns invokes the dms_enterprise.ListSensitiveColumns API synchronously
func (client *Client) ListSensitiveColumns(request *ListSensitiveColumnsRequest) (response *ListSensitiveColumnsResponse, err error) {
	response = CreateListSensitiveColumnsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSensitiveColumnsWithChan invokes the dms_enterprise.ListSensitiveColumns API asynchronously
func (client *Client) ListSensitiveColumnsWithChan(request *ListSensitiveColumnsRequest) (<-chan *ListSensitiveColumnsResponse, <-chan error) {
	responseChan := make(chan *ListSensitiveColumnsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSensitiveColumns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSensitiveColumnsWithCallback invokes the dms_enterprise.ListSensitiveColumns API asynchronously
func (client *Client) ListSensitiveColumnsWithCallback(request *ListSensitiveColumnsRequest, callback func(response *ListSensitiveColumnsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSensitiveColumnsResponse
		var err error
		defer close(result)
		response, err = client.ListSensitiveColumns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSensitiveColumnsRequest is the request struct for api ListSensitiveColumns
type ListSensitiveColumnsRequest struct {
	*requests.RpcRequest
	SchemaName    string           `position:"Query" name:"SchemaName"`
	ColumnName    string           `position:"Query" name:"ColumnName"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityLevel string           `position:"Query" name:"SecurityLevel"`
	DbId          requests.Integer `position:"Query" name:"DbId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Logic         requests.Boolean `position:"Query" name:"Logic"`
	TableName     string           `position:"Query" name:"TableName"`
}

// ListSensitiveColumnsResponse is the response struct for api ListSensitiveColumns
type ListSensitiveColumnsResponse struct {
	*responses.BaseResponse
	TotalCount          int64               `json:"TotalCount" xml:"TotalCount"`
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	ErrorCode           string              `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage        string              `json:"ErrorMessage" xml:"ErrorMessage"`
	Success             bool                `json:"Success" xml:"Success"`
	SensitiveColumnList SensitiveColumnList `json:"SensitiveColumnList" xml:"SensitiveColumnList"`
}

// CreateListSensitiveColumnsRequest creates a request to invoke ListSensitiveColumns API
func CreateListSensitiveColumnsRequest() (request *ListSensitiveColumnsRequest) {
	request = &ListSensitiveColumnsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListSensitiveColumns", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSensitiveColumnsResponse creates a response to parse from ListSensitiveColumns response
func CreateListSensitiveColumnsResponse() (response *ListSensitiveColumnsResponse) {
	response = &ListSensitiveColumnsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
