package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJobMonitorRule invokes the dts.CreateJobMonitorRule API synchronously
func (client *Client) CreateJobMonitorRule(request *CreateJobMonitorRuleRequest) (response *CreateJobMonitorRuleResponse, err error) {
	response = CreateCreateJobMonitorRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobMonitorRuleWithChan invokes the dts.CreateJobMonitorRule API asynchronously
func (client *Client) CreateJobMonitorRuleWithChan(request *CreateJobMonitorRuleRequest) (<-chan *CreateJobMonitorRuleResponse, <-chan error) {
	responseChan := make(chan *CreateJobMonitorRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJobMonitorRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobMonitorRuleWithCallback invokes the dts.CreateJobMonitorRule API asynchronously
func (client *Client) CreateJobMonitorRuleWithCallback(request *CreateJobMonitorRuleRequest, callback func(response *CreateJobMonitorRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobMonitorRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateJobMonitorRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobMonitorRuleRequest is the request struct for api CreateJobMonitorRule
type CreateJobMonitorRuleRequest struct {
	*requests.RpcRequest
	Type          string           `position:"Query" name:"Type"`
	DelayRuleTime requests.Integer `position:"Query" name:"DelayRuleTime"`
	Phone         string           `position:"Query" name:"Phone"`
	DtsJobId      string           `position:"Query" name:"DtsJobId"`
	State         string           `position:"Query" name:"State"`
}

// CreateJobMonitorRuleResponse is the response struct for api CreateJobMonitorRule
type CreateJobMonitorRuleResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DtsJobId       string `json:"DtsJobId" xml:"DtsJobId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateCreateJobMonitorRuleRequest creates a request to invoke CreateJobMonitorRule API
func CreateCreateJobMonitorRuleRequest() (request *CreateJobMonitorRuleRequest) {
	request = &CreateJobMonitorRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "CreateJobMonitorRule", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateJobMonitorRuleResponse creates a response to parse from CreateJobMonitorRule response
func CreateCreateJobMonitorRuleResponse() (response *CreateJobMonitorRuleResponse) {
	response = &CreateJobMonitorRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
