package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneNumberStatus invokes the dytnsapi.DescribePhoneNumberStatus API synchronously
func (client *Client) DescribePhoneNumberStatus(request *DescribePhoneNumberStatusRequest) (response *DescribePhoneNumberStatusResponse, err error) {
	response = CreateDescribePhoneNumberStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneNumberStatusWithChan invokes the dytnsapi.DescribePhoneNumberStatus API asynchronously
func (client *Client) DescribePhoneNumberStatusWithChan(request *DescribePhoneNumberStatusRequest) (<-chan *DescribePhoneNumberStatusResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneNumberStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneNumberStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneNumberStatusWithCallback invokes the dytnsapi.DescribePhoneNumberStatus API asynchronously
func (client *Client) DescribePhoneNumberStatusWithCallback(request *DescribePhoneNumberStatusRequest, callback func(response *DescribePhoneNumberStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneNumberStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneNumberStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneNumberStatusRequest is the request struct for api DescribePhoneNumberStatus
type DescribePhoneNumberStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePhoneNumberStatusResponse is the response struct for api DescribePhoneNumberStatus
type DescribePhoneNumberStatusResponse struct {
	*responses.BaseResponse
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PhoneStatus PhoneStatus `json:"PhoneStatus" xml:"PhoneStatus"`
}

// CreateDescribePhoneNumberStatusRequest creates a request to invoke DescribePhoneNumberStatus API
func CreateDescribePhoneNumberStatusRequest() (request *DescribePhoneNumberStatusRequest) {
	request = &DescribePhoneNumberStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribePhoneNumberStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePhoneNumberStatusResponse creates a response to parse from DescribePhoneNumberStatus response
func CreateDescribePhoneNumberStatusResponse() (response *DescribePhoneNumberStatusResponse) {
	response = &DescribePhoneNumberStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
