package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServiceAutoScaler invokes the eas.DescribeServiceAutoScaler API synchronously
func (client *Client) DescribeServiceAutoScaler(request *DescribeServiceAutoScalerRequest) (response *DescribeServiceAutoScalerResponse, err error) {
	response = CreateDescribeServiceAutoScalerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServiceAutoScalerWithChan invokes the eas.DescribeServiceAutoScaler API asynchronously
func (client *Client) DescribeServiceAutoScalerWithChan(request *DescribeServiceAutoScalerRequest) (<-chan *DescribeServiceAutoScalerResponse, <-chan error) {
	responseChan := make(chan *DescribeServiceAutoScalerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServiceAutoScaler(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServiceAutoScalerWithCallback invokes the eas.DescribeServiceAutoScaler API asynchronously
func (client *Client) DescribeServiceAutoScalerWithCallback(request *DescribeServiceAutoScalerRequest, callback func(response *DescribeServiceAutoScalerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServiceAutoScalerResponse
		var err error
		defer close(result)
		response, err = client.DescribeServiceAutoScaler(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServiceAutoScalerRequest is the request struct for api DescribeServiceAutoScaler
type DescribeServiceAutoScalerRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"ServiceName"`
	ClusterId   string `position:"Path" name:"ClusterId"`
}

// DescribeServiceAutoScalerResponse is the response struct for api DescribeServiceAutoScaler
type DescribeServiceAutoScalerResponse struct {
	*responses.BaseResponse
	RequestId   string                 `json:"RequestId" xml:"RequestId"`
	ServiceName string                 `json:"ServiceName" xml:"ServiceName"`
	MinReplica  int                    `json:"MinReplica" xml:"MinReplica"`
	MaxReplica  int                    `json:"MaxReplica" xml:"MaxReplica"`
	Strategies  map[string]interface{} `json:"Strategies" xml:"Strategies"`
}

// CreateDescribeServiceAutoScalerRequest creates a request to invoke DescribeServiceAutoScaler API
func CreateDescribeServiceAutoScalerRequest() (request *DescribeServiceAutoScalerRequest) {
	request = &DescribeServiceAutoScalerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DescribeServiceAutoScaler", "/api/v2/services/[ClusterId]/[ServiceName]/autoscaler", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeServiceAutoScalerResponse creates a response to parse from DescribeServiceAutoScaler response
func CreateDescribeServiceAutoScalerResponse() (response *DescribeServiceAutoScalerResponse) {
	response = &DescribeServiceAutoScalerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
