package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSnapshotGroup invokes the ecs.DeleteSnapshotGroup API synchronously
func (client *Client) DeleteSnapshotGroup(request *DeleteSnapshotGroupRequest) (response *DeleteSnapshotGroupResponse, err error) {
	response = CreateDeleteSnapshotGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSnapshotGroupWithChan invokes the ecs.DeleteSnapshotGroup API asynchronously
func (client *Client) DeleteSnapshotGroupWithChan(request *DeleteSnapshotGroupRequest) (<-chan *DeleteSnapshotGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteSnapshotGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSnapshotGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSnapshotGroupWithCallback invokes the ecs.DeleteSnapshotGroup API asynchronously
func (client *Client) DeleteSnapshotGroupWithCallback(request *DeleteSnapshotGroupRequest, callback func(response *DeleteSnapshotGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSnapshotGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteSnapshotGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSnapshotGroupRequest is the request struct for api DeleteSnapshotGroup
type DeleteSnapshotGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SnapshotGroupId      string           `position:"Query" name:"SnapshotGroupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteSnapshotGroupResponse is the response struct for api DeleteSnapshotGroup
type DeleteSnapshotGroupResponse struct {
	*responses.BaseResponse
	RequestId            string                                    `json:"RequestId" xml:"RequestId"`
	OperationProgressSet OperationProgressSetInDeleteSnapshotGroup `json:"OperationProgressSet" xml:"OperationProgressSet"`
}

// CreateDeleteSnapshotGroupRequest creates a request to invoke DeleteSnapshotGroup API
func CreateDeleteSnapshotGroupRequest() (request *DeleteSnapshotGroupRequest) {
	request = &DeleteSnapshotGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteSnapshotGroup", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSnapshotGroupResponse creates a response to parse from DeleteSnapshotGroup response
func CreateDeleteSnapshotGroupResponse() (response *DeleteSnapshotGroupResponse) {
	response = &DeleteSnapshotGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
