package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImages invokes the ecs.DescribeImages API synchronously
func (client *Client) DescribeImages(request *DescribeImagesRequest) (response *DescribeImagesResponse, err error) {
	response = CreateDescribeImagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImagesWithChan invokes the ecs.DescribeImages API asynchronously
func (client *Client) DescribeImagesWithChan(request *DescribeImagesRequest) (<-chan *DescribeImagesResponse, <-chan error) {
	responseChan := make(chan *DescribeImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImagesWithCallback invokes the ecs.DescribeImages API asynchronously
func (client *Client) DescribeImagesWithCallback(request *DescribeImagesRequest, callback func(response *DescribeImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImagesResponse
		var err error
		defer close(result)
		response, err = client.DescribeImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImagesRequest is the request struct for api DescribeImages
type DescribeImagesRequest struct {
	*requests.RpcRequest
	ActionType           string                  `position:"Query" name:"ActionType"`
	ImageOwnerId         requests.Integer        `position:"Query" name:"ImageOwnerId"`
	ResourceOwnerId      requests.Integer        `position:"Query" name:"ResourceOwnerId"`
	ImageId              string                  `position:"Query" name:"ImageId"`
	SnapshotId           string                  `position:"Query" name:"SnapshotId"`
	Usage                string                  `position:"Query" name:"Usage"`
	PageNumber           requests.Integer        `position:"Query" name:"PageNumber"`
	ImageOwnerAlias      string                  `position:"Query" name:"ImageOwnerAlias"`
	ResourceGroupId      string                  `position:"Query" name:"ResourceGroupId"`
	IsSupportIoOptimized requests.Boolean        `position:"Query" name:"IsSupportIoOptimized"`
	ImageName            string                  `position:"Query" name:"ImageName"`
	IsSupportCloudinit   requests.Boolean        `position:"Query" name:"IsSupportCloudinit"`
	IsPublic             requests.Boolean        `position:"Query" name:"IsPublic"`
	PageSize             requests.Integer        `position:"Query" name:"PageSize"`
	InstanceType         string                  `position:"Query" name:"InstanceType"`
	Tag                  *[]DescribeImagesTag    `position:"Query" name:"Tag"  type:"Repeated"`
	Architecture         string                  `position:"Query" name:"Architecture"`
	DryRun               requests.Boolean        `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string                  `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                  `position:"Query" name:"OwnerAccount"`
	ShowExpired          requests.Boolean        `position:"Query" name:"ShowExpired"`
	OSType               string                  `position:"Query" name:"OSType"`
	OwnerId              requests.Integer        `position:"Query" name:"OwnerId"`
	Filter               *[]DescribeImagesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	ImageFamily          string                  `position:"Query" name:"ImageFamily"`
	Status               string                  `position:"Query" name:"Status"`
}

// DescribeImagesTag is a repeated param struct in DescribeImagesRequest
type DescribeImagesTag struct {
	Value string `name:"value"`
	Key   string `name:"Key"`
}

// DescribeImagesFilter is a repeated param struct in DescribeImagesRequest
type DescribeImagesFilter struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeImagesResponse is the response struct for api DescribeImages
type DescribeImagesResponse struct {
	*responses.BaseResponse
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RegionId   string `json:"RegionId" xml:"RegionId"`
	Images     Images `json:"Images" xml:"Images"`
}

// CreateDescribeImagesRequest creates a request to invoke DescribeImages API
func CreateDescribeImagesRequest() (request *DescribeImagesRequest) {
	request = &DescribeImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeImages", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImagesResponse creates a response to parse from DescribeImages response
func CreateDescribeImagesResponse() (response *DescribeImagesResponse) {
	response = &DescribeImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
