package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableActivation invokes the ecs.DisableActivation API synchronously
func (client *Client) DisableActivation(request *DisableActivationRequest) (response *DisableActivationResponse, err error) {
	response = CreateDisableActivationResponse()
	err = client.DoAction(request, response)
	return
}

// DisableActivationWithChan invokes the ecs.DisableActivation API asynchronously
func (client *Client) DisableActivationWithChan(request *DisableActivationRequest) (<-chan *DisableActivationResponse, <-chan error) {
	responseChan := make(chan *DisableActivationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableActivation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableActivationWithCallback invokes the ecs.DisableActivation API asynchronously
func (client *Client) DisableActivationWithCallback(request *DisableActivationRequest, callback func(response *DisableActivationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableActivationResponse
		var err error
		defer close(result)
		response, err = client.DisableActivation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableActivationRequest is the request struct for api DisableActivation
type DisableActivationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ActivationId         string           `position:"Query" name:"ActivationId"`
}

// DisableActivationResponse is the response struct for api DisableActivation
type DisableActivationResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Activation Activation `json:"Activation" xml:"Activation"`
}

// CreateDisableActivationRequest creates a request to invoke DisableActivation API
func CreateDisableActivationRequest() (request *DisableActivationRequest) {
	request = &DisableActivationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DisableActivation", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableActivationResponse creates a response to parse from DisableActivation response
func CreateDisableActivationResponse() (response *DisableActivationResponse) {
	response = &DisableActivationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
