package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplicationEcu invokes the edas.ListApplicationEcu API synchronously
func (client *Client) ListApplicationEcu(request *ListApplicationEcuRequest) (response *ListApplicationEcuResponse, err error) {
	response = CreateListApplicationEcuResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationEcuWithChan invokes the edas.ListApplicationEcu API asynchronously
func (client *Client) ListApplicationEcuWithChan(request *ListApplicationEcuRequest) (<-chan *ListApplicationEcuResponse, <-chan error) {
	responseChan := make(chan *ListApplicationEcuResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplicationEcu(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationEcuWithCallback invokes the edas.ListApplicationEcu API asynchronously
func (client *Client) ListApplicationEcuWithCallback(request *ListApplicationEcuRequest, callback func(response *ListApplicationEcuResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationEcuResponse
		var err error
		defer close(result)
		response, err = client.ListApplicationEcu(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationEcuRequest is the request struct for api ListApplicationEcu
type ListApplicationEcuRequest struct {
	*requests.RoaRequest
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
	AppId           string `position:"Query" name:"AppId"`
}

// ListApplicationEcuResponse is the response struct for api ListApplicationEcu
type ListApplicationEcuResponse struct {
	*responses.BaseResponse
	Code        int                             `json:"Code" xml:"Code"`
	Message     string                          `json:"Message" xml:"Message"`
	RequestId   string                          `json:"RequestId" xml:"RequestId"`
	EcuInfoList EcuInfoListInListApplicationEcu `json:"EcuInfoList" xml:"EcuInfoList"`
}

// CreateListApplicationEcuRequest creates a request to invoke ListApplicationEcu API
func CreateListApplicationEcuRequest() (request *ListApplicationEcuRequest) {
	request = &ListApplicationEcuRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListApplicationEcu", "/pop/v5/resource/ecu_list", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListApplicationEcuResponse creates a response to parse from ListApplicationEcu response
func CreateListApplicationEcuResponse() (response *ListApplicationEcuResponse) {
	response = &ListApplicationEcuResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
