package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSwimmingLaneGroup invokes the edas.ListSwimmingLaneGroup API synchronously
func (client *Client) ListSwimmingLaneGroup(request *ListSwimmingLaneGroupRequest) (response *ListSwimmingLaneGroupResponse, err error) {
	response = CreateListSwimmingLaneGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListSwimmingLaneGroupWithChan invokes the edas.ListSwimmingLaneGroup API asynchronously
func (client *Client) ListSwimmingLaneGroupWithChan(request *ListSwimmingLaneGroupRequest) (<-chan *ListSwimmingLaneGroupResponse, <-chan error) {
	responseChan := make(chan *ListSwimmingLaneGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSwimmingLaneGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSwimmingLaneGroupWithCallback invokes the edas.ListSwimmingLaneGroup API asynchronously
func (client *Client) ListSwimmingLaneGroupWithCallback(request *ListSwimmingLaneGroupRequest, callback func(response *ListSwimmingLaneGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSwimmingLaneGroupResponse
		var err error
		defer close(result)
		response, err = client.ListSwimmingLaneGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSwimmingLaneGroupRequest is the request struct for api ListSwimmingLaneGroup
type ListSwimmingLaneGroupRequest struct {
	*requests.RoaRequest
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
}

// ListSwimmingLaneGroupResponse is the response struct for api ListSwimmingLaneGroup
type ListSwimmingLaneGroupResponse struct {
	*responses.BaseResponse
	Code      int                 `json:"Code" xml:"Code"`
	Message   string              `json:"Message" xml:"Message"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Data      []SwimmingLaneGroup `json:"Data" xml:"Data"`
}

// CreateListSwimmingLaneGroupRequest creates a request to invoke ListSwimmingLaneGroup API
func CreateListSwimmingLaneGroupRequest() (request *ListSwimmingLaneGroupRequest) {
	request = &ListSwimmingLaneGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListSwimmingLaneGroup", "/pop/v5/trafficmgnt/swimming_lane_groups", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSwimmingLaneGroupResponse creates a response to parse from ListSwimmingLaneGroup response
func CreateListSwimmingLaneGroupResponse() (response *ListSwimmingLaneGroupResponse) {
	response = &ListSwimmingLaneGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
