package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScaleK8sApplication invokes the edas.ScaleK8sApplication API synchronously
func (client *Client) ScaleK8sApplication(request *ScaleK8sApplicationRequest) (response *ScaleK8sApplicationResponse, err error) {
	response = CreateScaleK8sApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ScaleK8sApplicationWithChan invokes the edas.ScaleK8sApplication API asynchronously
func (client *Client) ScaleK8sApplicationWithChan(request *ScaleK8sApplicationRequest) (<-chan *ScaleK8sApplicationResponse, <-chan error) {
	responseChan := make(chan *ScaleK8sApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScaleK8sApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScaleK8sApplicationWithCallback invokes the edas.ScaleK8sApplication API asynchronously
func (client *Client) ScaleK8sApplicationWithCallback(request *ScaleK8sApplicationRequest, callback func(response *ScaleK8sApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScaleK8sApplicationResponse
		var err error
		defer close(result)
		response, err = client.ScaleK8sApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScaleK8sApplicationRequest is the request struct for api ScaleK8sApplication
type ScaleK8sApplicationRequest struct {
	*requests.RoaRequest
	Replicas requests.Integer `position:"Query" name:"Replicas"`
	AppId    string           `position:"Query" name:"AppId"`
	Timeout  requests.Integer `position:"Query" name:"Timeout"`
}

// ScaleK8sApplicationResponse is the response struct for api ScaleK8sApplication
type ScaleK8sApplicationResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Code          int    `json:"Code" xml:"Code"`
	Message       string `json:"Message" xml:"Message"`
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
}

// CreateScaleK8sApplicationRequest creates a request to invoke ScaleK8sApplication API
func CreateScaleK8sApplicationRequest() (request *ScaleK8sApplicationRequest) {
	request = &ScaleK8sApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ScaleK8sApplication", "/pop/v5/k8s/acs/k8s_apps", "Edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateScaleK8sApplicationResponse creates a response to parse from ScaleK8sApplication response
func CreateScaleK8sApplicationResponse() (response *ScaleK8sApplicationResponse) {
	response = &ScaleK8sApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
