package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageGatewayConfig invokes the ehpc.DescribeImageGatewayConfig API synchronously
func (client *Client) DescribeImageGatewayConfig(request *DescribeImageGatewayConfigRequest) (response *DescribeImageGatewayConfigResponse, err error) {
	response = CreateDescribeImageGatewayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageGatewayConfigWithChan invokes the ehpc.DescribeImageGatewayConfig API asynchronously
func (client *Client) DescribeImageGatewayConfigWithChan(request *DescribeImageGatewayConfigRequest) (<-chan *DescribeImageGatewayConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeImageGatewayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageGatewayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageGatewayConfigWithCallback invokes the ehpc.DescribeImageGatewayConfig API asynchronously
func (client *Client) DescribeImageGatewayConfigWithCallback(request *DescribeImageGatewayConfigRequest, callback func(response *DescribeImageGatewayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageGatewayConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageGatewayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageGatewayConfigRequest is the request struct for api DescribeImageGatewayConfig
type DescribeImageGatewayConfigRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeImageGatewayConfigResponse is the response struct for api DescribeImageGatewayConfig
type DescribeImageGatewayConfigResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Imagegw   Imagegw `json:"Imagegw" xml:"Imagegw"`
}

// CreateDescribeImageGatewayConfigRequest creates a request to invoke DescribeImageGatewayConfig API
func CreateDescribeImageGatewayConfigRequest() (request *DescribeImageGatewayConfigRequest) {
	request = &DescribeImageGatewayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DescribeImageGatewayConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeImageGatewayConfigResponse creates a response to parse from DescribeImageGatewayConfig response
func CreateDescribeImageGatewayConfigResponse() (response *DescribeImageGatewayConfigResponse) {
	response = &DescribeImageGatewayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
