package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAnycastEipAddresses invokes the eipanycast.ListAnycastEipAddresses API synchronously
func (client *Client) ListAnycastEipAddresses(request *ListAnycastEipAddressesRequest) (response *ListAnycastEipAddressesResponse, err error) {
	response = CreateListAnycastEipAddressesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAnycastEipAddressesWithChan invokes the eipanycast.ListAnycastEipAddresses API asynchronously
func (client *Client) ListAnycastEipAddressesWithChan(request *ListAnycastEipAddressesRequest) (<-chan *ListAnycastEipAddressesResponse, <-chan error) {
	responseChan := make(chan *ListAnycastEipAddressesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAnycastEipAddresses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAnycastEipAddressesWithCallback invokes the eipanycast.ListAnycastEipAddresses API asynchronously
func (client *Client) ListAnycastEipAddressesWithCallback(request *ListAnycastEipAddressesRequest, callback func(response *ListAnycastEipAddressesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAnycastEipAddressesResponse
		var err error
		defer close(result)
		response, err = client.ListAnycastEipAddresses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAnycastEipAddressesRequest is the request struct for api ListAnycastEipAddresses
type ListAnycastEipAddressesRequest struct {
	*requests.RpcRequest
	NextToken          string           `position:"Query" name:"NextToken"`
	InstanceChargeType string           `position:"Query" name:"InstanceChargeType"`
	BusinessStatus     string           `position:"Query" name:"BusinessStatus"`
	ServiceLocation    string           `position:"Query" name:"ServiceLocation"`
	AnycastEipAddress  string           `position:"Query" name:"AnycastEipAddress"`
	InternetChargeType string           `position:"Query" name:"InternetChargeType"`
	AnycastId          string           `position:"Query" name:"AnycastId"`
	Name               string           `position:"Query" name:"Name"`
	BindInstanceIds    *[]string        `position:"Query" name:"BindInstanceIds"  type:"Repeated"`
	MaxResults         requests.Integer `position:"Query" name:"MaxResults"`
	Status             string           `position:"Query" name:"Status"`
}

// ListAnycastEipAddressesResponse is the response struct for api ListAnycastEipAddresses
type ListAnycastEipAddressesResponse struct {
	*responses.BaseResponse
	TotalCount  int       `json:"TotalCount" xml:"TotalCount"`
	NextToken   string    `json:"NextToken" xml:"NextToken"`
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	AnycastList []Anycast `json:"AnycastList" xml:"AnycastList"`
}

// CreateListAnycastEipAddressesRequest creates a request to invoke ListAnycastEipAddresses API
func CreateListAnycastEipAddressesRequest() (request *ListAnycastEipAddressesRequest) {
	request = &ListAnycastEipAddressesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "ListAnycastEipAddresses", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAnycastEipAddressesResponse creates a response to parse from ListAnycastEipAddresses response
func CreateListAnycastEipAddressesResponse() (response *ListAnycastEipAddressesResponse) {
	response = &ListAnycastEipAddressesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
