package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogstash invokes the elasticsearch.DescribeLogstash API synchronously
func (client *Client) DescribeLogstash(request *DescribeLogstashRequest) (response *DescribeLogstashResponse, err error) {
	response = CreateDescribeLogstashResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogstashWithChan invokes the elasticsearch.DescribeLogstash API asynchronously
func (client *Client) DescribeLogstashWithChan(request *DescribeLogstashRequest) (<-chan *DescribeLogstashResponse, <-chan error) {
	responseChan := make(chan *DescribeLogstashResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogstash(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogstashWithCallback invokes the elasticsearch.DescribeLogstash API asynchronously
func (client *Client) DescribeLogstashWithCallback(request *DescribeLogstashRequest, callback func(response *DescribeLogstashResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogstashResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogstash(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogstashRequest is the request struct for api DescribeLogstash
type DescribeLogstashRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeLogstashResponse is the response struct for api DescribeLogstash
type DescribeLogstashResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    ResultInDescribeLogstash `json:"Result" xml:"Result"`
}

// CreateDescribeLogstashRequest creates a request to invoke DescribeLogstash API
func CreateDescribeLogstashRequest() (request *DescribeLogstashRequest) {
	request = &DescribeLogstashRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeLogstash", "/openapi/logstashes/[InstanceId]", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeLogstashResponse creates a response to parse from DescribeLogstash response
func CreateDescribeLogstashResponse() (response *DescribeLogstashResponse) {
	response = &DescribeLogstashResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
