package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePipelineManagementConfig invokes the elasticsearch.DescribePipelineManagementConfig API synchronously
func (client *Client) DescribePipelineManagementConfig(request *DescribePipelineManagementConfigRequest) (response *DescribePipelineManagementConfigResponse, err error) {
	response = CreateDescribePipelineManagementConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePipelineManagementConfigWithChan invokes the elasticsearch.DescribePipelineManagementConfig API asynchronously
func (client *Client) DescribePipelineManagementConfigWithChan(request *DescribePipelineManagementConfigRequest) (<-chan *DescribePipelineManagementConfigResponse, <-chan error) {
	responseChan := make(chan *DescribePipelineManagementConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePipelineManagementConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePipelineManagementConfigWithCallback invokes the elasticsearch.DescribePipelineManagementConfig API asynchronously
func (client *Client) DescribePipelineManagementConfigWithCallback(request *DescribePipelineManagementConfigRequest, callback func(response *DescribePipelineManagementConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePipelineManagementConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribePipelineManagementConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePipelineManagementConfigRequest is the request struct for api DescribePipelineManagementConfig
type DescribePipelineManagementConfigRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// DescribePipelineManagementConfigResponse is the response struct for api DescribePipelineManagementConfig
type DescribePipelineManagementConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribePipelineManagementConfigRequest creates a request to invoke DescribePipelineManagementConfig API
func CreateDescribePipelineManagementConfigRequest() (request *DescribePipelineManagementConfigRequest) {
	request = &DescribePipelineManagementConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribePipelineManagementConfig", "/openapi/logstashes/[InstanceId]/pipeline-management-config", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribePipelineManagementConfigResponse creates a response to parse from DescribePipelineManagementConfig response
func CreateDescribePipelineManagementConfigResponse() (response *DescribePipelineManagementConfigResponse) {
	response = &DescribePipelineManagementConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
