package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReinstallCollector invokes the elasticsearch.ReinstallCollector API synchronously
func (client *Client) ReinstallCollector(request *ReinstallCollectorRequest) (response *ReinstallCollectorResponse, err error) {
	response = CreateReinstallCollectorResponse()
	err = client.DoAction(request, response)
	return
}

// ReinstallCollectorWithChan invokes the elasticsearch.ReinstallCollector API asynchronously
func (client *Client) ReinstallCollectorWithChan(request *ReinstallCollectorRequest) (<-chan *ReinstallCollectorResponse, <-chan error) {
	responseChan := make(chan *ReinstallCollectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReinstallCollector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReinstallCollectorWithCallback invokes the elasticsearch.ReinstallCollector API asynchronously
func (client *Client) ReinstallCollectorWithCallback(request *ReinstallCollectorRequest, callback func(response *ReinstallCollectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReinstallCollectorResponse
		var err error
		defer close(result)
		response, err = client.ReinstallCollector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReinstallCollectorRequest is the request struct for api ReinstallCollector
type ReinstallCollectorRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	ResId       string `position:"Path" name:"ResId"`
}

// ReinstallCollectorResponse is the response struct for api ReinstallCollector
type ReinstallCollectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateReinstallCollectorRequest creates a request to invoke ReinstallCollector API
func CreateReinstallCollectorRequest() (request *ReinstallCollectorRequest) {
	request = &ReinstallCollectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ReinstallCollector", "/openapi/collectors/[ResId]/actions/reinstall", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReinstallCollectorResponse creates a response to parse from ReinstallCollector response
func CreateReinstallCollectorResponse() (response *ReinstallCollectorResponse) {
	response = &ReinstallCollectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
