package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartLogstash invokes the elasticsearch.RestartLogstash API synchronously
func (client *Client) RestartLogstash(request *RestartLogstashRequest) (response *RestartLogstashResponse, err error) {
	response = CreateRestartLogstashResponse()
	err = client.DoAction(request, response)
	return
}

// RestartLogstashWithChan invokes the elasticsearch.RestartLogstash API asynchronously
func (client *Client) RestartLogstashWithChan(request *RestartLogstashRequest) (<-chan *RestartLogstashResponse, <-chan error) {
	responseChan := make(chan *RestartLogstashResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartLogstash(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartLogstashWithCallback invokes the elasticsearch.RestartLogstash API asynchronously
func (client *Client) RestartLogstashWithCallback(request *RestartLogstashRequest, callback func(response *RestartLogstashResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartLogstashResponse
		var err error
		defer close(result)
		response, err = client.RestartLogstash(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartLogstashRequest is the request struct for api RestartLogstash
type RestartLogstashRequest struct {
	*requests.RoaRequest
	InstanceId  string           `position:"Path" name:"InstanceId"`
	ClientToken string           `position:"Query" name:"clientToken"`
	Force       requests.Boolean `position:"Query" name:"force"`
}

// RestartLogstashResponse is the response struct for api RestartLogstash
type RestartLogstashResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestartLogstashRequest creates a request to invoke RestartLogstash API
func CreateRestartLogstashRequest() (request *RestartLogstashRequest) {
	request = &RestartLogstashRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "RestartLogstash", "/openapi/logstashes/[InstanceId]/actions/restart", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartLogstashResponse creates a response to parse from RestartLogstash response
func CreateRestartLogstashResponse() (response *RestartLogstashResponse) {
	response = &RestartLogstashResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
