package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowJob invokes the emr.ListFlowJob API synchronously
func (client *Client) ListFlowJob(request *ListFlowJobRequest) (response *ListFlowJobResponse, err error) {
	response = CreateListFlowJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowJobWithChan invokes the emr.ListFlowJob API asynchronously
func (client *Client) ListFlowJobWithChan(request *ListFlowJobRequest) (<-chan *ListFlowJobResponse, <-chan error) {
	responseChan := make(chan *ListFlowJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowJobWithCallback invokes the emr.ListFlowJob API asynchronously
func (client *Client) ListFlowJobWithCallback(request *ListFlowJobRequest, callback func(response *ListFlowJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowJobResponse
		var err error
		defer close(result)
		response, err = client.ListFlowJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowJobRequest is the request struct for api ListFlowJob
type ListFlowJobRequest struct {
	*requests.RpcRequest
	Type       string           `position:"Query" name:"Type"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Name       string           `position:"Query" name:"Name"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Id         string           `position:"Query" name:"Id"`
	Adhoc      requests.Boolean `position:"Query" name:"Adhoc"`
	ProjectId  string           `position:"Query" name:"ProjectId"`
}

// ListFlowJobResponse is the response struct for api ListFlowJob
type ListFlowJobResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	Total      int     `json:"Total" xml:"Total"`
	JobList    JobList `json:"JobList" xml:"JobList"`
}

// CreateListFlowJobRequest creates a request to invoke ListFlowJob API
func CreateListFlowJobRequest() (request *ListFlowJobRequest) {
	request = &ListFlowJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowJob", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFlowJobResponse creates a response to parse from ListFlowJob response
func CreateListFlowJobResponse() (response *ListFlowJobResponse) {
	response = &ListFlowJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
