package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyEpnInstance invokes the ens.ModifyEpnInstance API synchronously
func (client *Client) ModifyEpnInstance(request *ModifyEpnInstanceRequest) (response *ModifyEpnInstanceResponse, err error) {
	response = CreateModifyEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyEpnInstanceWithChan invokes the ens.ModifyEpnInstance API asynchronously
func (client *Client) ModifyEpnInstanceWithChan(request *ModifyEpnInstanceRequest) (<-chan *ModifyEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *ModifyEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyEpnInstanceWithCallback invokes the ens.ModifyEpnInstance API asynchronously
func (client *Client) ModifyEpnInstanceWithCallback(request *ModifyEpnInstanceRequest, callback func(response *ModifyEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.ModifyEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyEpnInstanceRequest is the request struct for api ModifyEpnInstance
type ModifyEpnInstanceRequest struct {
	*requests.RpcRequest
	NetworkingModel         string           `position:"Query" name:"NetworkingModel"`
	InternetMaxBandwidthOut requests.Integer `position:"Query" name:"InternetMaxBandwidthOut"`
	EPNInstanceId           string           `position:"Query" name:"EPNInstanceId"`
	EPNInstanceName         string           `position:"Query" name:"EPNInstanceName"`
}

// ModifyEpnInstanceResponse is the response struct for api ModifyEpnInstance
type ModifyEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyEpnInstanceRequest creates a request to invoke ModifyEpnInstance API
func CreateModifyEpnInstanceRequest() (request *ModifyEpnInstanceRequest) {
	request = &ModifyEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyEpnInstanceResponse creates a response to parse from ModifyEpnInstance response
func CreateModifyEpnInstanceResponse() (response *ModifyEpnInstanceResponse) {
	response = &ModifyEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
