package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEcsImage invokes the faas.UpdateEcsImage API synchronously
// api document: https://help.aliyun.com/api/faas/updateecsimage.html
func (client *Client) UpdateEcsImage(request *UpdateEcsImageRequest) (response *UpdateEcsImageResponse, err error) {
	response = CreateUpdateEcsImageResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEcsImageWithChan invokes the faas.UpdateEcsImage API asynchronously
// api document: https://help.aliyun.com/api/faas/updateecsimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEcsImageWithChan(request *UpdateEcsImageRequest) (<-chan *UpdateEcsImageResponse, <-chan error) {
	responseChan := make(chan *UpdateEcsImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEcsImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEcsImageWithCallback invokes the faas.UpdateEcsImage API asynchronously
// api document: https://help.aliyun.com/api/faas/updateecsimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEcsImageWithCallback(request *UpdateEcsImageRequest, callback func(response *UpdateEcsImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEcsImageResponse
		var err error
		defer close(result)
		response, err = client.UpdateEcsImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEcsImageRequest is the request struct for api UpdateEcsImage
type UpdateEcsImageRequest struct {
	*requests.RpcRequest
	ShellUniqueId string `position:"Query" name:"ShellUniqueId"`
	ToolsVersion  string `position:"Query" name:"ToolsVersion"`
	ECSImageName  string `position:"Query" name:"ECSImageName"`
	Id            string `position:"Query" name:"Id"`
}

// UpdateEcsImageResponse is the response struct for api UpdateEcsImage
type UpdateEcsImageResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ImageId       string `json:"ImageId" xml:"ImageId"`
	ShellUniqueId string `json:"ShellUniqueId" xml:"ShellUniqueId"`
	ECSImageName  string `json:"ECSImageName" xml:"ECSImageName"`
	ToolsVersion  string `json:"ToolsVersion" xml:"ToolsVersion"`
}

// CreateUpdateEcsImageRequest creates a request to invoke UpdateEcsImage API
func CreateUpdateEcsImageRequest() (request *UpdateEcsImageRequest) {
	request = &UpdateEcsImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2020-02-17", "UpdateEcsImage", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEcsImageResponse creates a response to parse from UpdateEcsImage response
func CreateUpdateEcsImageResponse() (response *UpdateEcsImageResponse) {
	response = &UpdateEcsImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
