package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtEagleEye invokes the ft.FtEagleEye API synchronously
func (client *Client) FtEagleEye(request *FtEagleEyeRequest) (response *FtEagleEyeResponse, err error) {
	response = CreateFtEagleEyeResponse()
	err = client.DoAction(request, response)
	return
}

// FtEagleEyeWithChan invokes the ft.FtEagleEye API asynchronously
func (client *Client) FtEagleEyeWithChan(request *FtEagleEyeRequest) (<-chan *FtEagleEyeResponse, <-chan error) {
	responseChan := make(chan *FtEagleEyeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtEagleEye(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtEagleEyeWithCallback invokes the ft.FtEagleEye API asynchronously
func (client *Client) FtEagleEyeWithCallback(request *FtEagleEyeRequest, callback func(response *FtEagleEyeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtEagleEyeResponse
		var err error
		defer close(result)
		response, err = client.FtEagleEye(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtEagleEyeRequest is the request struct for api FtEagleEye
type FtEagleEyeRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// FtEagleEyeResponse is the response struct for api FtEagleEye
type FtEagleEyeResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Name            string `json:"Name" xml:"Name"`
	EagleEyeTraceId string `json:"eagleEyeTraceId" xml:"eagleEyeTraceId"`
}

// CreateFtEagleEyeRequest creates a request to invoke FtEagleEye API
func CreateFtEagleEyeRequest() (request *FtEagleEyeRequest) {
	request = &FtEagleEyeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtEagleEye", "", "")
	request.Method = requests.POST
	return
}

// CreateFtEagleEyeResponse creates a response to parse from FtEagleEye response
func CreateFtEagleEyeResponse() (response *FtEagleEyeResponse) {
	response = &FtEagleEyeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
