package goodstech

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeFurnitureSpu invokes the goodstech.RecognizeFurnitureSpu API synchronously
func (client *Client) RecognizeFurnitureSpu(request *RecognizeFurnitureSpuRequest) (response *RecognizeFurnitureSpuResponse, err error) {
	response = CreateRecognizeFurnitureSpuResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeFurnitureSpuWithChan invokes the goodstech.RecognizeFurnitureSpu API asynchronously
func (client *Client) RecognizeFurnitureSpuWithChan(request *RecognizeFurnitureSpuRequest) (<-chan *RecognizeFurnitureSpuResponse, <-chan error) {
	responseChan := make(chan *RecognizeFurnitureSpuResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeFurnitureSpu(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeFurnitureSpuWithCallback invokes the goodstech.RecognizeFurnitureSpu API asynchronously
func (client *Client) RecognizeFurnitureSpuWithCallback(request *RecognizeFurnitureSpuRequest, callback func(response *RecognizeFurnitureSpuResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeFurnitureSpuResponse
		var err error
		defer close(result)
		response, err = client.RecognizeFurnitureSpu(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeFurnitureSpuRequest is the request struct for api RecognizeFurnitureSpu
type RecognizeFurnitureSpuRequest struct {
	*requests.RpcRequest
	XLength  requests.Float `position:"Body" name:"XLength"`
	ZLength  requests.Float `position:"Body" name:"ZLength"`
	ImageURL string         `position:"Body" name:"ImageURL"`
	YLength  requests.Float `position:"Body" name:"YLength"`
}

// RecognizeFurnitureSpuResponse is the response struct for api RecognizeFurnitureSpu
type RecognizeFurnitureSpuResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeFurnitureSpuRequest creates a request to invoke RecognizeFurnitureSpu API
func CreateRecognizeFurnitureSpuRequest() (request *RecognizeFurnitureSpuRequest) {
	request = &RecognizeFurnitureSpuRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("goodstech", "2019-12-30", "RecognizeFurnitureSpu", "goodstech", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeFurnitureSpuResponse creates a response to parse from RecognizeFurnitureSpu response
func CreateRecognizeFurnitureSpuResponse() (response *RecognizeFurnitureSpuResponse) {
	response = &RecognizeFurnitureSpuResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
