package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLive invokes the idrsservice.UpdateLive API synchronously
func (client *Client) UpdateLive(request *UpdateLiveRequest) (response *UpdateLiveResponse, err error) {
	response = CreateUpdateLiveResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveWithChan invokes the idrsservice.UpdateLive API asynchronously
func (client *Client) UpdateLiveWithChan(request *UpdateLiveRequest) (<-chan *UpdateLiveResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLive(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveWithCallback invokes the idrsservice.UpdateLive API asynchronously
func (client *Client) UpdateLiveWithCallback(request *UpdateLiveRequest, callback func(response *UpdateLiveResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveResponse
		var err error
		defer close(result)
		response, err = client.UpdateLive(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveRequest is the request struct for api UpdateLive
type UpdateLiveRequest struct {
	*requests.RpcRequest
	LiveId string `position:"Query" name:"LiveId"`
	UserId string `position:"Query" name:"UserId"`
	Status string `position:"Query" name:"Status"`
}

// UpdateLiveResponse is the response struct for api UpdateLive
type UpdateLiveResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateLiveRequest creates a request to invoke UpdateLive API
func CreateUpdateLiveRequest() (request *UpdateLiveRequest) {
	request = &UpdateLiveRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "UpdateLive", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveResponse creates a response to parse from UpdateLive response
func CreateUpdateLiveResponse() (response *UpdateLiveResponse) {
	response = &UpdateLiveResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
