package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectQRCodes invokes the imm.DetectQRCodes API synchronously
func (client *Client) DetectQRCodes(request *DetectQRCodesRequest) (response *DetectQRCodesResponse, err error) {
	response = CreateDetectQRCodesResponse()
	err = client.DoAction(request, response)
	return
}

// DetectQRCodesWithChan invokes the imm.DetectQRCodes API asynchronously
func (client *Client) DetectQRCodesWithChan(request *DetectQRCodesRequest) (<-chan *DetectQRCodesResponse, <-chan error) {
	responseChan := make(chan *DetectQRCodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectQRCodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectQRCodesWithCallback invokes the imm.DetectQRCodes API asynchronously
func (client *Client) DetectQRCodesWithCallback(request *DetectQRCodesRequest, callback func(response *DetectQRCodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectQRCodesResponse
		var err error
		defer close(result)
		response, err = client.DetectQRCodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectQRCodesRequest is the request struct for api DetectQRCodes
type DetectQRCodesRequest struct {
	*requests.RpcRequest
	Project string `position:"Query" name:"Project"`
	SrcUris string `position:"Query" name:"SrcUris"`
}

// DetectQRCodesResponse is the response struct for api DetectQRCodes
type DetectQRCodesResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	SuccessDetails []SuccessDetailsItem `json:"SuccessDetails" xml:"SuccessDetails"`
	FailDetails    []FailDetailsItem    `json:"FailDetails" xml:"FailDetails"`
}

// CreateDetectQRCodesRequest creates a request to invoke DetectQRCodes API
func CreateDetectQRCodesRequest() (request *DetectQRCodesRequest) {
	request = &DetectQRCodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DetectQRCodes", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectQRCodesResponse creates a response to parse from DetectQRCodes response
func CreateDetectQRCodesResponse() (response *DetectQRCodesResponse) {
	response = &DetectQRCodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
