package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEdgeDriver invokes the iot.QueryEdgeDriver API synchronously
func (client *Client) QueryEdgeDriver(request *QueryEdgeDriverRequest) (response *QueryEdgeDriverResponse, err error) {
	response = CreateQueryEdgeDriverResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEdgeDriverWithChan invokes the iot.QueryEdgeDriver API asynchronously
func (client *Client) QueryEdgeDriverWithChan(request *QueryEdgeDriverRequest) (<-chan *QueryEdgeDriverResponse, <-chan error) {
	responseChan := make(chan *QueryEdgeDriverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEdgeDriver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEdgeDriverWithCallback invokes the iot.QueryEdgeDriver API asynchronously
func (client *Client) QueryEdgeDriverWithCallback(request *QueryEdgeDriverRequest, callback func(response *QueryEdgeDriverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEdgeDriverResponse
		var err error
		defer close(result)
		response, err = client.QueryEdgeDriver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEdgeDriverRequest is the request struct for api QueryEdgeDriver
type QueryEdgeDriverRequest struct {
	*requests.RpcRequest
	DriverName    string           `position:"Query" name:"DriverName"`
	Type          requests.Integer `position:"Query" name:"Type"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QueryEdgeDriverResponse is the response struct for api QueryEdgeDriver
type QueryEdgeDriverResponse struct {
	*responses.BaseResponse
	RequestId    string                `json:"RequestId" xml:"RequestId"`
	Success      bool                  `json:"Success" xml:"Success"`
	Code         string                `json:"Code" xml:"Code"`
	ErrorMessage string                `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryEdgeDriver `json:"Data" xml:"Data"`
}

// CreateQueryEdgeDriverRequest creates a request to invoke QueryEdgeDriver API
func CreateQueryEdgeDriverRequest() (request *QueryEdgeDriverRequest) {
	request = &QueryEdgeDriverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryEdgeDriver", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEdgeDriverResponse creates a response to parse from QueryEdgeDriver response
func CreateQueryEdgeDriverResponse() (response *QueryEdgeDriverResponse) {
	response = &QueryEdgeDriverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
