package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAllEcsWhiteList invokes the jarvis.CreateAllEcsWhiteList API synchronously
// api document: https://help.aliyun.com/api/jarvis/createallecswhitelist.html
func (client *Client) CreateAllEcsWhiteList(request *CreateAllEcsWhiteListRequest) (response *CreateAllEcsWhiteListResponse, err error) {
	response = CreateCreateAllEcsWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAllEcsWhiteListWithChan invokes the jarvis.CreateAllEcsWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createallecswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAllEcsWhiteListWithChan(request *CreateAllEcsWhiteListRequest) (<-chan *CreateAllEcsWhiteListResponse, <-chan error) {
	responseChan := make(chan *CreateAllEcsWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAllEcsWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAllEcsWhiteListWithCallback invokes the jarvis.CreateAllEcsWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createallecswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAllEcsWhiteListWithCallback(request *CreateAllEcsWhiteListRequest, callback func(response *CreateAllEcsWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAllEcsWhiteListResponse
		var err error
		defer close(result)
		response, err = client.CreateAllEcsWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAllEcsWhiteListRequest is the request struct for api CreateAllEcsWhiteList
type CreateAllEcsWhiteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SrcIP           string           `position:"Query" name:"SrcIP"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	SourceCode      string           `position:"Query" name:"SourceCode"`
}

// CreateAllEcsWhiteListResponse is the response struct for api CreateAllEcsWhiteList
type CreateAllEcsWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
}

// CreateCreateAllEcsWhiteListRequest creates a request to invoke CreateAllEcsWhiteList API
func CreateCreateAllEcsWhiteListRequest() (request *CreateAllEcsWhiteListRequest) {
	request = &CreateAllEcsWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "CreateAllEcsWhiteList", "jarvis", "openAPI")
	return
}

// CreateCreateAllEcsWhiteListResponse creates a response to parse from CreateAllEcsWhiteList response
func CreateCreateAllEcsWhiteListResponse() (response *CreateAllEcsWhiteListResponse) {
	response = &CreateAllEcsWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
