package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayStatusStat invokes the linkwan.GetGatewayStatusStat API synchronously
func (client *Client) GetGatewayStatusStat(request *GetGatewayStatusStatRequest) (response *GetGatewayStatusStatResponse, err error) {
	response = CreateGetGatewayStatusStatResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayStatusStatWithChan invokes the linkwan.GetGatewayStatusStat API asynchronously
func (client *Client) GetGatewayStatusStatWithChan(request *GetGatewayStatusStatRequest) (<-chan *GetGatewayStatusStatResponse, <-chan error) {
	responseChan := make(chan *GetGatewayStatusStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayStatusStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayStatusStatWithCallback invokes the linkwan.GetGatewayStatusStat API asynchronously
func (client *Client) GetGatewayStatusStatWithCallback(request *GetGatewayStatusStatRequest, callback func(response *GetGatewayStatusStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayStatusStatResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayStatusStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayStatusStatRequest is the request struct for api GetGatewayStatusStat
type GetGatewayStatusStatRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	GwEui         string `position:"Query" name:"GwEui"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetGatewayStatusStatResponse is the response struct for api GetGatewayStatusStat
type GetGatewayStatusStatResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetGatewayStatusStatRequest creates a request to invoke GetGatewayStatusStat API
func CreateGetGatewayStatusStatRequest() (request *GetGatewayStatusStatRequest) {
	request = &GetGatewayStatusStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetGatewayStatusStat", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayStatusStatResponse creates a response to parse from GetGatewayStatusStat response
func CreateGetGatewayStatusStatResponse() (response *GetGatewayStatusStatResponse) {
	response = &GetGatewayStatusStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
