package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeTransferPacket invokes the linkwan.GetNodeTransferPacket API synchronously
func (client *Client) GetNodeTransferPacket(request *GetNodeTransferPacketRequest) (response *GetNodeTransferPacketResponse, err error) {
	response = CreateGetNodeTransferPacketResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeTransferPacketWithChan invokes the linkwan.GetNodeTransferPacket API asynchronously
func (client *Client) GetNodeTransferPacketWithChan(request *GetNodeTransferPacketRequest) (<-chan *GetNodeTransferPacketResponse, <-chan error) {
	responseChan := make(chan *GetNodeTransferPacketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeTransferPacket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeTransferPacketWithCallback invokes the linkwan.GetNodeTransferPacket API asynchronously
func (client *Client) GetNodeTransferPacketWithCallback(request *GetNodeTransferPacketRequest, callback func(response *GetNodeTransferPacketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeTransferPacketResponse
		var err error
		defer close(result)
		response, err = client.GetNodeTransferPacket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeTransferPacketRequest is the request struct for api GetNodeTransferPacket
type GetNodeTransferPacketRequest struct {
	*requests.RpcRequest
	Base64EncodedMacPayload string           `position:"Query" name:"Base64EncodedMacPayload"`
	IotInstanceId           string           `position:"Query" name:"IotInstanceId"`
	LogMillis               requests.Integer `position:"Query" name:"LogMillis"`
	DevEui                  string           `position:"Query" name:"DevEui"`
	ApiProduct              string           `position:"Body" name:"ApiProduct"`
	ApiRevision             string           `position:"Body" name:"ApiRevision"`
}

// GetNodeTransferPacketResponse is the response struct for api GetNodeTransferPacket
type GetNodeTransferPacketResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Success   bool                        `json:"Success" xml:"Success"`
	Data      DataInGetNodeTransferPacket `json:"Data" xml:"Data"`
}

// CreateGetNodeTransferPacketRequest creates a request to invoke GetNodeTransferPacket API
func CreateGetNodeTransferPacketRequest() (request *GetNodeTransferPacketRequest) {
	request = &GetNodeTransferPacketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeTransferPacket", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeTransferPacketResponse creates a response to parse from GetNodeTransferPacket response
func CreateGetNodeTransferPacketResponse() (response *GetNodeTransferPacketResponse) {
	response = &GetNodeTransferPacketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
